﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Text.RegularExpressions;

namespace memoQSampleCMSConnector
{
	internal class CMS_Session_Virtual  //Demo CMS session generating random files
	{
		private const string xliffFrame = @"<?xml version=""1.0"" encoding=""UTF-8""?><xliff version=""1.2""><file original=""d:\test.txt"" source-language=""!!source!!"" target-language=""!!target!!""><body><trans-unit id=""1""><source><![CDATA[!!translatable!!]]></source><target /></trans-unit></body></file></xliff>";

		private static string[] content = new string[] { "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen", "twenty" };

		private static Random rnd = new Random();

		internal static Dictionary<string, TranslatableAsset> GetTranslatableContent()
		{
			Dictionary<string, TranslatableAsset> result = new Dictionary<string, TranslatableAsset>();

            var files = Directory.GetFiles(ConfigurationHelper.Config.InputFolderPath, "*.*", SearchOption.TopDirectoryOnly);
            foreach (string file in files) {
                TranslatableAsset newItem = new TranslatableAsset();
                newItem.Key = Path.GetFileName(file);
                newItem.Stream = File.OpenRead(file);
                newItem.FileType = Path.GetExtension(file).Remove(0,1);
                result.Add(newItem.Key, newItem);
            }


			//int numberOfFiles = rnd.Next(0, 5);

			//for (int fileCount = 0; fileCount < numberOfFiles; fileCount++)
			//{
			//	string fileContent = xliffFrame.Replace("!!source!!", ConfigurationHelper.Config.xliffSource).Replace("!!target!!", ConfigurationHelper.Config.xliffTarget).Replace("!!translatable!!", content[rnd.Next(0, 19)]);
			//	Stream fileStream = Helper.GenerateStreamFromString(fileContent);

			//	string fileName = "FileName-" + Guid.NewGuid().ToString().Substring(0, 4);
			//	if (!result.ContainsKey(fileName))
			//	{
			//		result.Add(fileName, fileStream);
			//	}
			//}
			return result;
		}

		internal static void DeliverTranslations(Dictionary<string, Stream> downloadedFiles)
		{
			foreach (string fileID in downloadedFiles.Keys)
			{
				string translation = (new StreamReader(downloadedFiles[fileID])).ReadToEnd();

                string outputFileName = ConfigurationHelper.Config.OutputFolderPath + fileID;
                try
                {
                    if (!Directory.Exists(ConfigurationHelper.Config.OutputFolderPath)) Directory.CreateDirectory(ConfigurationHelper.Config.OutputFolderPath);
                }
                catch
                {
                    System.Windows.Forms.MessageBox.Show("Could not create folder '" + ConfigurationHelper.Config.OutputFolderPath + "', can't write output");
                }


                try
                {                    
                    if (File.Exists(outputFileName)) File.Delete(outputFileName);
                }
                catch {
                    System.Windows.Forms.MessageBox.Show("Could not delete '" + outputFileName + "', can't write output");
                }

                try
                {
                    
                    FileStream outputFile = File.OpenWrite(outputFileName);
                    //StreamWriter sw = new StreamWriter(outputFile, System.Text.Encoding.UTF8);
                    BinaryWriter bw = new BinaryWriter(outputFile);
                    bw.Write(translation.ToCharArray());
                    bw.Close();
                    //sw.Write(translation);
                    //sw.Close();                    
                }
                catch
                {
                    System.Windows.Forms.MessageBox.Show("Couldn't create or write '" + outputFileName + "', can't write output");
                }

                
				string message = "File delivered to CMS: " + fileID + " - Translation is: " + translation;
				Log.AddLog(message);
			}
		}
	}
}